package com.icetech.cloudcenter.domain.request;

import com.icetech.common.annotation.NotNull;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 远程升级参数
 */
@ToString
@Setter
@Getter
public class DeviceUpgradeRequest implements Serializable{

    /**
     * 设备序列号
     */
    @NotNull
    private String sn;
    /**
     * 目标版本号
     */
    @NotNull
    private String newFirmwareVer;
    /**
     * 操作人账号名
     */
    @NotNull
    private String operAccount;
    /**
     * 升级执行时间
     */
    @NotNull
    private String actionTime;

    /**
     * 设备类型 固定为1相机
     */
    private Integer deviceType = 1;
}
