package com.icetech.cloudcenter.domain.request;

import com.icetech.common.annotation.NotNull;
import com.icetech.common.constants.OrderCarInfoConstant;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

@Setter
@Getter
@ToString
public class CarExitRequest implements Serializable {
    @NotNull
    private Integer openFlag;
    private String orderNum;
    @NotNull
    private Integer property;
    private String plateNum;

    @NotNull
    private Long exitTime;
    /**
     * 相机上报的原始离场时间
     */
    private Long originalExitTime;
    @NotNull
    private Integer triggerType;
    private String plateColor;
    private String carBrand;
    private String carColor;
    private Integer carType;
    private Integer shamFlag;
    private Integer reliability;
    private Integer type;
    private String smallImage;
    private String maxImage;
    /**
     * 总金额
     */
    private String totalAmount;
    /**
     * 已支付金额
     */
    private String paidAmount;
    /**
     * 优惠金额
     */
    private String discountAmount;
    private Integer paidAmountFen;
    private Integer discountAmountFen;
    @NotNull(condition = "triggerType == 3")
    private String triggerNo;

    /**
     * 辅助参数
     */
    //出入口名称
    private String inandoutName;
    private String inandoutCode;
    private String parkCode;
    private Long parkId;
    /**
     * 是否先离场后付费
     */
    private Integer isAfterPay;
    /**
     * 需缴费
     */
    private String unpayPrice;
    /**
     * 允许出场
     */
    private Boolean allowExit;
    private String operAccount;
    /**
     * 出场方式：1车牌识别，2遥控器抬杆，3无牌车扫码，4软件人工，5断电应急
     */
    private Integer exitWay = 1;
    /**
     * 出场渠道
     */
    private Integer exitTerminal;

    /**
     * 全嵌套和半嵌套车场脱机情况下，当前区域外的其他区域费用明细，主通道相机上报
     */
    private List<OtherRegionFee> otherRegionFee;
    /**
     * 上次支付时间
     */
    private Long lastPayTime;
    /**
     * 备注
     */
    private String exitRemark;
    /**
     * 是否模糊匹配订单
     */
    private Boolean fuzzyOrder;

    @Getter
    @Setter
    @ToString
    public static class OtherRegionFee implements Serializable  {
        private Long regionId;
        private Integer paidAmountFen;
        private Integer discountAmountFen;
    }

    public Integer getExitWay() {
        if (this.exitWay == null) {
            if (this.plateNum != null && this.plateNum.startsWith("临")) {
                this.exitWay = OrderCarInfoConstant.IN_OUT_WAY_QR_CODE;
                return OrderCarInfoConstant.IN_OUT_WAY_QR_CODE;
            }
            this.exitWay = OrderCarInfoConstant.IN_OUT_WAY_PLATE_NUM;
            return OrderCarInfoConstant.IN_OUT_WAY_PLATE_NUM;
        }
        return exitWay;
    }

    public Long getOriginalExitTime() {
        if (originalExitTime == null) {
            return exitTime;
        }
        return originalExitTime;
    }

}
