package com.icetech.cloudcenter.domain.pay;

import com.icetech.cloudcenter.domain.vo.NotPayDetailVo;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @Auther: lisc
 * @Date: 2018/10/15 14:44
 * @Description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PayTo implements Serializable {
    private Integer bizType = BizType.PARK_PAY.getBizType();
    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 本次交易流水号
     */
    private String tradeNo;
    /**
     * 本次订单号
     */
    private String orderNum;
    /**
     * 通道id
     */
    private String channelId;
    /**
     * 车牌号
     */
    private String plateNum;
    /**
     * 用户id
     */
    private String unionId;
    /**
     * 入场时间
     */
    private Long enterTime;
    /**
     * 无牌车标识
     */
    private String type;
    /**
     * 是否是断电应急
     */
    private Boolean isOffline;
    /**
     * 外部交易流水号
     */
    private String outTradeNo;
    /** 欠费订单列表 */
    protected List<NotPayDetailVo> notPayDetails;
    /**
     * 支付口类型
     */
    protected Integer exType;

    /**
     * 银行单号
     */
    private String bankOrderId;
}
