package com.icetech.cloudcenter.domain.pay;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Auther: lisc
 * @Date: 2018/10/15 14:44
 * @Description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class MonthPayInfo implements Serializable {
    private Integer bizType = BizType.MONTH_PAY.getBizType();
    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 操作人
     */
    private String userName;
    /**
     * 通道id
     */
    private String channelId;
    /**
     * 车牌号
     */
    private String plateNum;
    /**
     * 入场时间
     */
    private Long enterTime;
    /**
     * 订单编号
     */
    private String orderNum;
    /**
     * 续费月卡的id
     */
    private Integer monthInfoId;
    /**
     * 月卡产品id
     */
    private Integer productId;
    /**
     * 月卡生效开始时间
     */
    private Date startTime;
    /**
     * 月卡结束日期
     */
    private Date endTime;
    /**
     * 月卡产品数量
     */
    private Integer productNum;
    /**
     * 缴费来源:0公众号; 1:H5场内缴费; 2出口H5缴费
     */
    private Integer source;
}
