package com.icetech.cloudcenter.domain.parkvip;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.io.Serializable;

/**
 * 车场vip类型
 * @author wangzhiwei
 */
@AllArgsConstructor
@Getter
public enum ParkVipEnum implements Serializable {
    month(1,"连续月卡",30),
    quarter(2,"连续季卡",90),
    year(3,"连续年卡",365),
    ;
    private Integer type;
    private String desc;
    private Integer day;


    public static String getDesc(Integer type){
        for (ParkVipEnum value : ParkVipEnum.values()) {
            if (value.getType().equals(type)){
                return value.getDesc();
            }
        }
        return null;
    }

    public static Integer getDay(Integer type){
        for (ParkVipEnum value : ParkVipEnum.values()) {
            if (value.getType().equals(type)){
                return value.getDay();
            }
        }
        return null;
    }

}
