package com.icetech.cloudcenter.domain.parkvip;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 车场会员
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wangzhiwei
 * @version 1.0 @date 2021-12-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@TableName("ice_park_vip")
public class ParkVip implements Serializable {

    private static final long serialVersionUID=1L;
    public static final Integer MAX_USER=3;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 车场id
     */
    private Integer parkId;

    /**
     * vip id
     */
    private Integer vipId;

    /**
     * 会员生效时间
     */
    private Date effectiveTime;

    /**
     * 会员过期时间
     */
    private Date expirationTime;

    /**
     * 累计天数
     */
    private Integer  dayNum;

    /**
     * 热线号码
     */
    private String phoneNum;
    /**
     * 联系电话
     */
    private String linkPhone;
    /**
     * 状态 1=有效
     */
    private Integer status;
    /**
     * 是否首次开通
     */
    private Boolean firstOpen;

    /**
     * 授权最多用户数 默认3个
     */
    private Integer maxUserNum;
    /**
     * vip套餐id
     */
    private Integer vipRuleId;
    /**
     *申请时间
     */
    private Date applyTime;
    /**
     * 申请人
     */
    private String applyName;
    /**
     * 审核人
     */
    private String approveName;
    /**
     * 审核时间
     */
    private Date approveTime;
    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;


}
