package com.icetech.cloudcenter.domain.park.query;

import com.baomidou.mybatisplus.annotation.TableField;
import com.icetech.cloudcenter.domain.response.MonthProductDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 车位查询信息
 * @author wangzhiwei
 */
@Data
public class ParkVisitInfo implements Serializable {
    /**
     * 车场id
     */
    private Long id;
    private String parkCode;
    /**
     * 车场名称
     */
    private String parkName;
    /**
     * 车场业态(为空查询全部) 0：其他 1：商超 2：商务写字楼 3：公共场馆 4 星级酒店 5：住宅 6：医院 7：学校 8：交通枢纽 9：商业综合体 10产业园 11路侧',
     */
    private Integer parkProperty;
    /**
     * 经度
     */
    private Double lng;
    /**
     * 纬度
     */
    private Double lat;
    /**
     * 距离
     */
    private Double location;

    /**
     * 联系方式
     */
    private String phone = "";

    /**
     * 空车位，用于显示
     */
    private Integer freeSpace = 0;
    /**
     * 实际空车位
     */
    private Integer realFreeSpace = 0;
    /**
     * 车场总车位
     */
    private Integer totalNum = 0;
    /**
     * 支持公众号访客预约 0否 1是
     */
    protected Integer isVisit;
    /**
     * 访客车辆是否收费 0否 1是
     */
    protected Integer visitIscharge;
    /**
     * 访客预约限制次数 默认为0
     */
    protected Integer visitInoutNum;

}
