package com.icetech.cloudcenter.domain.park.query;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Description ParkTrusteeshipRecordParam
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/6/29 17:48
 */
@Data
public class ParkTrusteeshipRecordParam implements Serializable {

    /**
     * 车场id
     */
    private List<Long> parkIds;

    /**
     * 所属机构
     */
    private List<Integer> institutionIds;

    /**
     * 操作开始时间
     */
    private String operateStartTime;

    /**
     * 操作结束时间
     */
    private String operateEndTime;

    /**
     * 托管模式：1-甲方自建坐席托管，2-知位自营坐席托管
     */
    private List<Integer> trusteeshipModels;

    /**
     * 缴费类型，1-开通托管服务，2-托管续费
     */
    private List<Integer> payTypes;

    /**
     * 页码
     */
    private Integer pageNo;
    /**
     * 分页大小
     */
    private Integer pageSize;
}
