package com.icetech.cloudcenter.domain.park.query;

import com.icetech.cloudcenter.domain.charge.dto.ChargeRuleCfgDTO;
import com.icetech.cloudcenter.domain.response.MonthProductDto;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 车位查询信息
 * @author wangzhiwei
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ParkSpaceMsgInfo implements Serializable {
    /**
     * 车场id
     */
    private Long id;
    private String parkCode;
    /**
     * 车场名称
     */
    private String parkName;
    /**
     * 车场业态(为空查询全部) 0：其他 1：商超 2：商务写字楼 3：公共场馆 4 星级酒店 5：住宅 6：医院 7：学校 8：交通枢纽 9：商业综合体 10产业园 11路侧',
     */
    private Integer parkProperty;
    /**
     * 经度
     */
    private Double lng;
    /**
     * 纬度
     */
    private Double lat;
    /**
     * 距离
     */
    private Double location;
    private Integer freeSpace;
    /**
     * 月卡产品信息
     */
    private MonthProductDto monthProduct;
    /**
     * 计费规则详情
     */
    private ChargeRuleCfgDTO chargeRuleCfgDTO;

    /**
     *  1：通用自然天计费，2：白天夜间计费，3:二十四小时计费
     */
    public Integer sBilltype;

}
