package com.icetech.cloudcenter.domain.park;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * Description: 
 * Version1.0 2022-07-08 by wgy 创建
 * @author wanggy 
 */
@Data
@NoArgsConstructor
public class ParkListGroup implements Serializable {

    @ApiModelProperty(value = "总记录数", required = true, example = "100", position = 1)
    private Long total;

    @ApiModelProperty(value = "总页数", required = true, example = "10", position = 2)
    private String totalPage;

    @ApiModelProperty(value = "返回数据结果", required = true, position = 3)
    private List<ParkList> rows;

    public ParkListGroup(Long total, String totalPage, List<ParkList> rows) {
        this.total = total;
        this.totalPage = totalPage;
        this.rows = rows;
    }
}
