package com.icetech.cloudcenter.domain.park;

import lombok.Data;

import java.io.Serializable;

/**
 * @author wangzhiwei
 */
@Data
public class ParkInOutDeviceDto implements Serializable {
    /**
     * 车场id
     */
    private Integer parkId;
    /**
     * 设备id
     */
    private Integer deviceId;
    /**
     * 设备状态
     */
    private Integer delFlag;
    /**
     * 车场编码
     */
    private String parkCode;
    /**
     * 车场姓名
     */
    private String parkName;

    /**
     * 通道编码
     */
    private String channelCode;
    /**
     * 通道名称
     */
    private String channelName;

    /**
     * 通道类型 1入口 2出口
     */
    private Integer channelType;
    /**
     * 图片路径(缓存加载)
     */
    private String imageUrl;
    /**
     * 设备序列号
     */
    private String serialNumber;
    /**
     * 协议版本号
     */
    private String protocolVer;
    /**
     * 设备状态
     */
    private Integer status;

    /**
     * 数据上报方式:1端云;2端网云;3纯云
     */
    private Integer dataCollection;

}
