package com.icetech.cloudcenter.domain.notpay;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 虚假车牌项
 * @Author: fangct
 * @CreateTime: 2023-07-20  10:31
 * @Version: 1.0
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ShamPlateDTO implements Serializable {
    /**
     * id
     */
    private Long id;
    /**
     * 车场名称
     */
    private String parkName;
    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 车辆类型(1临时车2月卡车3特殊车辆，默认1)
     */
    private Integer type;

    /**
     * 报警时间
     */
    private Date alarmTime;

    /**
     * 报警通道名称
     */
    private String channelName;

    /**
     * 关联车牌号
     */
    private String relPlateNum;

    /**
     * 虚假车辆照片
     */
    private String carImage;

    /**
     * 关联车辆照片
     */
    private String relCarImage;
    /**
     * 入口名称
     */
    private String enterNo;

    /**
     * 订单状态:1在场;2离场;3已取消;4异常离场
     */
    private Integer serviceStatus;


    /**
     * 是否有子订单，0：否，1：是，默认为0
     */
    private Integer hasSon;
}
