package com.icetech.cloudcenter.domain.notpay;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Description: 欠费补缴的订单
 * @Author: wangzhiwei
 * @CreateTime: 2023-03-07  10:31
 * @Version: 1.0
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class NotPayOrderListDTO implements Serializable {
    /**
     * 总缴费金额
     */
    private BigDecimal totalPrice;
    /**
     * 总数量
     */
    private Integer totalNum;
    /**
     * 总记录
     */
    private List<NotPayOrderDTO> detailList;
}
