package com.icetech.cloudcenter.domain.enumeration;

import lombok.Getter;

/**
 * 下发业务对应的类型
 *
 */
public enum RobotServiceEnum {

	预缴费("notifyPrepay",1),
	缴费查询("queryFee",2),
    无牌车入场("noplateEnter",3),
    无牌车离场("noplateExit",4),
    远程开关闸("remoteSwitch",5),
    月卡("issuedCard",6),
	优惠下发("discountInfo",7),
	黑名单下发("blacklist",10),
	月卡暂停恢复("cardPauseRecover",6),
	实时通道数据("channelData",16),
	请求入场("reqEnter",17),
	语音显示屏内容("showAndSay",18),
	车辆预约("orderEnter",22),
	修改停车费用("modifyFee",27),
	;





	@Getter
	private final String serviceName;
	@Getter
	private final Integer serviceType;

	private RobotServiceEnum(String serviceName, Integer serviceType) {
		this.serviceName = serviceName;
		this.serviceType = serviceType;
	}

	public static String getServiceName(Integer serviceType) {
		for (RobotServiceEnum p : RobotServiceEnum.values()) {
			if (serviceType.equals(p.getServiceType())) {
				return p.serviceName;
			}
		}
		return null;
	}

	public static Integer getServiceType(String serviceName) {
		for (RobotServiceEnum p : RobotServiceEnum.values()) {
			if (serviceName.equals(p.getServiceName())) {
				return p.serviceType;
			}
		}
		return null;
	}


}
