package com.icetech.cloudcenter.domain.enumeration;

import lombok.Getter;

@Getter
public enum PncVersionEnum {

    版本1("N1.0", 1),
    版本2("N1.1.11", 2),
    版本3("N1.1.12", 3),
    版本4("N1.2", 4),
    版本5("N2.0", 5),
    版本6("N2.2.0.1", 6),
    /**
     * 订单轨迹版本
     */
    版本7("N2.3.0.0", 7),
    版本8("N2.3.1.0", 8),

    /**
     * 语音屏显等按通道配置
     */
    版本2400("N2.4.0.0", 2400),
    /**
     * 分时段放行配置
     */
    版本2410("N2.4.1.0", 2410),
    版本2500("N2.5.0.0", 2500),
    版本2540("N2.5.4.0", 2540),
    版本FS("NFS2.5.4.0", 2540),
    ;

    private String version;
    private int index;

    private PncVersionEnum(String version, int index){
        this.version = version;
        this.index = index;
    }
    public static int getIndex(String version){
        for (PncVersionEnum p2cVersionEnum : PncVersionEnum.values()){
            if (p2cVersionEnum.version.equals(version)){
                return p2cVersionEnum.index;
            }
        }
        return 0;
    }
}
