package com.icetech.cloudcenter.domain.enumeration;

import lombok.Getter;

@Getter
public enum P2rCmdEnum {

    设备认证("auth_device",1),
    心跳包("heartbeat",2),
    设备异常信息上报("error_msg",3),
    现金收费上报("rec_cash",4),
    读码结果上报("pay_code",5),
    小票领取成功上报("ticket_got",6),
    屏显语音信息下发("hint",7),
    支付信息展示("show_pay_info",8),
    打印机信息下发("print_info",9),
    ;

    private String cmd;
    private Integer cmdType;

    private P2rCmdEnum(String cmd, Integer cmdType) {
        this.cmd = cmd;
        this.cmdType = cmdType;
    }

    public static String getCmd(Integer cmdType) {
        for (P2rCmdEnum p : P2rCmdEnum.values()) {
            if (cmdType.equals(p.getCmdType())) {
                return p.cmd;
            }
        }
        return null;
    }

    public static Integer getCmdType(String cmd) {
        for (P2rCmdEnum p : P2rCmdEnum.values()) {
            if (cmd.equals(p.getCmd())) {
                return p.cmdType;
            }
        }
        return null;
    }

}
