package com.icetech.cloudcenter.domain.enumeration;

import com.icetech.common.utils.StringUtils;
import lombok.Getter;

@Getter
public enum MorVersionEnum {

    版本1("1.0.0", 1),
    版本2("1.0.1", 2),
    版本3("1.1.0", 3),
    ;

    private String version;
    private int index;

    private MorVersionEnum(String version, int index){
        this.version = version;
        this.index = index;
    }
    public static int getIndex(String version){
        if (version == null){
            return 0;
        }
        for (MorVersionEnum p2cVersionEnum : MorVersionEnum.values()){
            if (p2cVersionEnum.version.equals(version)){
                return p2cVersionEnum.index;
            }
        }
        return 0;
    }
    
    public static float getNumber(String version) {
        if (StringUtils.isBlank(version)) {
            return 0;
        }
        String[] split = version.split("\\.");
        if (split.length == 1) {
            return 0;
        }
        String newVer = split[0] + ".";
        for (int i = 1; i < split.length; i++) {
            String node = split[i];
            String tempNode = node.length() == 1 ? "0" + node : node;
            newVer = newVer + tempNode;
        }
        return Float.parseFloat(newVer);
    }

}
