package com.icetech.cloudcenter.domain.enumeration;

import lombok.Getter;

@Getter
public enum MorDownCmdEnum {

    标记疑似跟车("notpay_car",100),
    请求车辆视频("apply_car_video",101),
    OSS配置下发("oss_config",102),
    属性配置下发("property_set",103),
    ;

    private String cmd;
    private Integer cmdType;

    MorDownCmdEnum(String cmd, Integer cmdType) {
        this.cmd = cmd;
        this.cmdType = cmdType;
    }

    public static String getCmd(Integer cmdType) {
        for (MorDownCmdEnum p : MorDownCmdEnum.values()) {
            if (cmdType.equals(p.getCmdType())) {
                return p.cmd;
            }
        }
        return null;
    }

    public static Integer getCmdType(String cmd) {
        for (MorDownCmdEnum p : MorDownCmdEnum.values()) {
            if (cmd.equals(p.getCmd())) {
                return p.cmdType;
            }
        }
        return null;
    }

}
