package com.icetech.cloudcenter.domain.enumeration;

import lombok.Getter;

@Getter
public enum KeyCodeEnum {

    A("key1"),
    B("key2"),
    C("key3"),
    D("key4"),
    ;

    private String key;

    private KeyCodeEnum(String key){
        this.key = key;
    }

    public static String getKey(String name){
        for (KeyCodeEnum codeEnum : KeyCodeEnum.values()) {
            if (name.equals(codeEnum.name())){
                return codeEnum.getKey();
            }
        }
        return "";
    }

}
