package com.icetech.cloudcenter.domain.enumeration;

import lombok.Getter;

@Getter
public enum ItcDownCmdEnum {

    屏显信息("hint",13),
    OSS配置下发("oss_config",32),
    属性配置下发("property_set",42),
    属性获取("property_get",43),
    剩余空车位("free_space",24),
    ;

    private String cmd;
    private Integer cmdType;

    ItcDownCmdEnum(String cmd, Integer cmdType) {
        this.cmd = cmd;
        this.cmdType = cmdType;
    }

    public static String getCmd(Integer cmdType) {
        for (ItcDownCmdEnum p : ItcDownCmdEnum.values()) {
            if (cmdType.equals(p.getCmdType())) {
                return p.cmd;
            }
        }
        return null;
    }

    public static Integer getCmdType(String cmd) {
        for (ItcDownCmdEnum p : ItcDownCmdEnum.values()) {
            if (cmd.equals(p.getCmd())) {
                return p.cmdType;
            }
        }
        return null;
    }

}
