package com.icetech.cloudcenter.domain.customer;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2023-11-24 11:30
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class CustomerServicePageDTO implements Serializable {

    /**
     * 电话
     */
    private String phone;

    /**
     * 编号
     */
    private String code;

    /**
     * 机构id
     */
    private Long institutionId;

    /**
     * 第几页
     */
    private Integer pageNo = 1;

    /**
     * 每页展示多少条
     */
    private Integer pageSize = 10;
}
