package com.icetech.cloudcenter.domain.constants;

import java.util.HashMap;
import java.util.Map;

/**
 * 语音播报
 * @author fangct
 */
public class SayElementConstants {

    /**
     * 动态播报内容集合，key是节点名称，value为替换后的内容模板。
     * 如：<4>京A12345<4/>，4为value，%为内容
     */
    public static Map<String, String> SAY_ELEMENT = new HashMap<>();
    static {
        SAY_ELEMENT.put("4", "%");
        SAY_ELEMENT.put("6", "剩余%天");
        SAY_ELEMENT.put("7", "停车%");
        SAY_ELEMENT.put("8", "请缴费%元");
        SAY_ELEMENT.put("9", "一路平安");
        SAY_ELEMENT.put("10", "欢迎光临");
        SAY_ELEMENT.put("11", "请等待人工确认");
        SAY_ELEMENT.put("12", "车位已满");
        SAY_ELEMENT.put("13", "禁止通行");
        SAY_ELEMENT.put("14", "临时车");
        SAY_ELEMENT.put("15", "月卡车");
        /**
         * D2：剩余车位、D3：车牌号、D4：车辆类型、D5：月卡剩余天数、
         * D6：停车时长、D7：需支付金额、D8：车型；
         */
        SAY_ELEMENT.put("D2", "剩余车位%个");
        SAY_ELEMENT.put("D3", "%");
        SAY_ELEMENT.put("D4", "%");
        SAY_ELEMENT.put("D5", "剩余%天");
        SAY_ELEMENT.put("D6", "停车%");
        SAY_ELEMENT.put("D7", "请缴费%元");
        SAY_ELEMENT.put("D8", "%");
        /**
         * S10：一路平安、S11：欢迎光临、S12：请等待人工确认、S13：无牌车扫码入场、
         * S14：祝您早日康复、S15：欢迎回家、S16：祝您工作愉快、S17：请安全驾驶、
         * S18：请勿乱停乱放、S19：此车无权限、S20：谢谢惠顾、S21：祝您一天都有好心情、
         * S22：请扫码缴费、S23：欢迎下次光临，S24：无入场信息，请呼叫管理员，
         * S26：临时车禁止通行，S27：车位已满，S28：无牌车扫码支付，S29：限行车辆，禁止通行，
         * S30：车位已占。
         */
        SAY_ELEMENT.put("S10", "一路平安");
        SAY_ELEMENT.put("S11", "欢迎光临");
        SAY_ELEMENT.put("S12", "请等待人工确认");
        SAY_ELEMENT.put("S13", "无牌车扫码入场");
        SAY_ELEMENT.put("S14", "祝您早日康复");
        SAY_ELEMENT.put("S15", "欢迎回家");
        SAY_ELEMENT.put("S16", "祝您工作愉快");
        SAY_ELEMENT.put("S17", "请安全驾驶");
        SAY_ELEMENT.put("S18", "请勿乱停乱放");
        SAY_ELEMENT.put("S19", "此车无权限");
        SAY_ELEMENT.put("S20", "谢谢惠顾");
        SAY_ELEMENT.put("S21", "祝您一天都有好心情");
        SAY_ELEMENT.put("S22", "请扫码缴费");
        SAY_ELEMENT.put("S23", "欢迎下次光临");
        SAY_ELEMENT.put("S24", "无入场信息，请呼叫管理员");
        SAY_ELEMENT.put("S26", "临时车禁止通行");
        SAY_ELEMENT.put("S27", "车位已满");
        SAY_ELEMENT.put("S28", "无牌车扫码支付");
        SAY_ELEMENT.put("S29", "限行车辆，禁止通行");
        SAY_ELEMENT.put("S30", "车位已占");

    }
}
