package com.icetech.cloudcenter.domain.constants;

import java.io.Serializable;

/**
 * @author wanggang
 * @create 2021-08-27 14:46
 */
public class PayChannelConstants implements Serializable {

    /**
     * 停车场出口支付
     */
    public static final Integer PARKING_EXIT = 1;

    /**
     * 平台支付
     */
    public static final Integer ONLINE = 2;

    /**
     * 自助支付
     */
    public static final Integer SELF_HELP = 3;

    /**
     * 中央收费站
     */
    public static final Integer TOLL_STATION = 4;

    /**
     * 第三方支付
     */
    public static final Integer THIRD_PARTY = 5;

    /**
     * 云岗亭
     */
    public static final Integer YGT = 6;

    /**
     * 对讲立柱
     */
    public static final Integer INTERCOM_COLUMN = 7;

    /**
     * 机器人支付
     */
    public static final Integer ROBOT_PAY = 8;

    /**
     * 公众号支付
     */
    public static final Integer MP_PAY = 9;
    /**
     * 遥控器
     */
    public static final Integer REMOTE_SWITCH = 10;
    /**
     * 公众号支付
     */
    public static final Integer ITC = 12;
    /**
     * 车场帮APP
     */
    public static final Integer APP = 13;
    /**
     * 云坐席
     */
    public static final Integer CLOUD_ZX = 14;
    /**
     * 本地坐席
     */
    public static final Integer LOCAL_ZX = 15;

    public static Integer getPayChannelFromExitTerminal(Integer exitTerminal) {
        if (exitTerminal == null) {
            return null;
        }
        switch (exitTerminal) {
            case 3 :
                return YGT;
            case 1 :
                return CLOUD_ZX;
            case 5 :
                return LOCAL_ZX;
            case 2 :
                return APP;
            default:
                break;
        }
        return null;
    }
}
