package com.icetech.cloudcenter.domain.charge.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 按次计费
 *
 * @author fangct
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class OnceChargeCfgDTO implements Serializable {
    /**
     * 是否开启每次收费开关（1:是，2:否，默认1）
     */
    public Integer sIsopenoncecharge;
    /**
     * 每次收费金额元
     */
    public Float sOncechargefee;
    /**
     * 每次收费金额元_大型车
     */
    public Float sOncechargefee_big;
    /**
     * 是否开启按分钟收费开关（1:是，2:否，默认2）
     */
    public Integer sIsopenother2;
    /**
     * 多少分钟范围
     */
    public Integer sTimeFrame;
    /**
     * 多少分钟范围计费金额元
     */
    public Float sTimeFrameOncefee;
    /**
     * 多少分钟范围计费金额元_大型车
     */
    public Float sTimeFrameOncefee_big;
    /**
     * 超时多少分钟范围每次收费金额元
     */
    public Float sOtherTimeFrameOncefee;
    /**
     * 超时多少分钟范围每次收费金额元_大型车
     */
    public Float sOtherTimeFrameOncefee_big;
    /**
     * 是否有附加选择项（1:是，2:否，默认2）
     */
    public Integer sIsattachoption;
    /**
     * 附加选择超过分钟数
     */
    public Integer sOverTime;
    /**
     * 加收过夜费元
     */
    public Float sAddOvernightFee;
    /**
     * 加收过夜费元_大型车
     */
    public Float sAddOvernightFee_big;

}
