package com.icetech.cloudcenter.api.third;

import com.icetech.third.domain.entity.third.ThirdInfo;
import com.icetech.third.domain.entity.third.ThirdPark;

import java.util.List;

/**
 * 第三方与车场关联信息DAO
 * @author fangct
 */
public interface ThirdParkService{

    ThirdPark selectByParkId(Long parkId);

    /**
     * 根据车场ID查询第三方信息
     * @param parkId
     * @return
     */
    List<ThirdInfo> selectThirdByParkId(Long parkId);

    ThirdInfo selectThirdByParkIdPID(Long parkId, String pid);

    List<Long> selectParkByPid(String pid);

    /**
     * 校验车场是否含有指定服务推送权限
     * @param parkId
     * @param serviceName
     * @return
     */
    boolean checkPermissionService(long parkId, String serviceName);
    Integer insertInfoByThird(ThirdPark thirdPark);

    /**
     * 获取支持无感支付车场的第三方配置
     * @param parkId
     * @return
     */
    ThirdInfo selectNoSenConfig(Long parkId);

    List<ThirdInfo> selectNoSenConfigs(Long parkId);

    /**
     * 通过主键删除三方和车场关联关系
     * @param ids
     */
    Integer deleteByIds(List<Integer> ids);

    /**
     * 通过车场id获取车场关联三方配置
     * @param parkId
     * @return
     */
    List<ThirdPark> findAllByParkId(Long parkId);

    /**
     * 根据车场和服务名查询有权限的三方列表
     * @param parkId 车场ID
     * @param serviceName 服务名
     * @return 三方列表
     */
    List<ThirdInfo> selectThirdByParkIdAndService(Long parkId, String serviceName);
}
