package com.icetech.cloudcenter.api.third;

import com.icetech.third.domain.entity.third.ThirdAttribute;
import com.icetech.db.mybatis.base.service.IBaseService;

/**
 * 三方属性表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2022-09-15
 */
public interface ThirdAttributeService extends IBaseService<ThirdAttribute> {

    /**
     * Description: 根据ID查询 三方属性表对象信息 <br>
     * Version1.0 2022-09-15 by wanggang创建
     *
     * @param id 对象id
     * @return ThirdAttribute
     */
    ThirdAttribute getThirdAttributeById (Long id);

    /**
     * Description: 新增  三方属性表对象信息 <br>
     * Version1.0 2022-09-15 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addThirdAttribute (ThirdAttribute entity);

    /**
     * Description: 修改 三方属性表对象信息 <br>
     * Version1.0 2022-09-15 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyThirdAttribute (ThirdAttribute entity);

    /**
     * Description: 删除  三方属性表对象信息 <br>
     * Version1.0 2022-09-15 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeThirdAttributeById (Long id);
}
