package com.icetech.cloudcenter.api.store;

import com.icetech.cloudcenter.domain.request.ExitCommonRequest;
import com.icetech.cloudcenter.domain.response.QueryOrderFeeResponse;
import com.icetech.fee.domain.entity.storecard.StoreCard;
import com.icetech.fee.domain.entity.storecard.StoreCardPlate;
import com.icetech.fee.domain.entity.storecard.StoreCardRecord;
import com.icetech.fee.domain.entity.storecard.StoreCardUsed;
import com.icetech.order.domain.dto.StoredCardRecordDto;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.common.domain.response.ObjectResponse;

import java.math.BigDecimal;
import java.util.List;

/**
 * TODO
 *
 * @author zhangpengzhan
 * @date 2020/8/3 14:00
 * @description: 储值卡
 */
public interface StoreCardService {

    /**
     * 获取储值卡详情
     * @param cardId
     * @return
     */
    ObjectResponse<StoreCard> getStoreCardDetail(Integer cardId);

    /**
     * 根据车牌储值卡绑定，批量查询储值卡信息
     * @param storeCardPlateList
     * @return
     */
    ObjectResponse<List<StoreCard>> getStoreCardList(List<StoreCardPlate> storeCardPlateList);

    /**
     *获取有效期内的储值卡
     * @param plate
     * @param parkId
     * @return
     */
    ObjectResponse<StoreCard> getValidStoreCards(String plate,Long parkId);

    /**
     * 根据车牌获取绑定储值卡号
     * @param plate
     * @return
     */
    ObjectResponse<List<StoreCardPlate>> getStoreCardPlate(String plate);

    /**
     * 更新储值卡余额信息
     * @param storeCard
     * @return
     */
    ObjectResponse updateStoreCardBalance(StoreCard storeCard);

    /**
     * 储值卡扣费
     * @param queryOrderFeeResponse
     * @return
     */
    ObjectResponse<StoreCard> chargeStoreCard(QueryOrderFeeResponse queryOrderFeeResponse,Long parkId);

    /**
     * 储值卡扣费
     * @param request 离场请求
     * @return
     */
    ObjectResponse<StoreCard> deductStoreCard(ExitCommonRequest request, ExitCommonRequest.PaidInfo paidInfo, OrderInfo orderInfo);

    /**
     * 更新储值卡余额信息
     * @param parkId
     * @param plateNum
     * @return
     */
    ObjectResponse<BigDecimal> getStoreCardBalance(Long parkId, String plateNum);

    /**
     * 根据记录ID获取储值卡修改记录
     * @param recordId 记录ID
     * @return
     */
    ObjectResponse<StoreCardRecord> getStoreCardRecordById(long recordId);

    ObjectResponse<StoreCardUsed> getStoreCardUsedById(long usedId);

    /**
     * 统计储值卡的收入
     * @param parkIds
     * @param startTime
     * @param endTime
     * @param type  操作类型1 新增 2 充值 3 编辑 4 删除
     * @return
     */
    List<StoreCardRecord> getStoreCarRecords(List<Long> parkIds,String startTime, String endTime,Integer type);

    /**
     * 统计数量
     * @param parkIds
     * @param startTime
     * @param endTime
     * @param type
     * @return
     */
    Integer countRecords(List<Long> parkIds,String startTime, String endTime,Integer type);

    /**
     * 计算金额
     * @param parkIds
     * @param startTime
     * @param endTime
     * @param type
     * @return
     */
    Double sumRecords(List<Long> parkIds,String startTime, String endTime,Integer type);

    /**
     * 查询操作记录
     * @param storedCardRecordDto 请求参数
     * @return 结果
     */
    List<StoredCardRecordDto> getStoredCardRecords(StoredCardRecordDto storedCardRecordDto);

    /**
     * 根据ID查询操作记录
     * @param id ID
     * @return 记录
     */
    StoreCardRecord getStoredCardRecordById(Long id);
}
