package com.icetech.cloudcenter.api.report;

import com.icetech.report.domain.entity.TempCarStatistics;
import com.icetech.db.mybatis.base.service.IBaseService;

import java.util.List;

/**
 * 临时车日统计表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-10-09
 */
public interface TempCarStatisticsService extends IBaseService<TempCarStatistics> {

    /**
     * Description: 根据ID查询 临时车日统计表对象信息 <br>
     * Version1.0 2021-10-09 by wanggang创建
     *
     * @param id 对象id
     * @return TempCarStatistics
     */
    TempCarStatistics getTempCarStatisticsById (Long id);

    /**
     * Description: 新增  临时车日统计表对象信息 <br>
     * Version1.0 2021-10-09 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addTempCarStatistics (TempCarStatistics entity);

    /**
     * Description: 修改 临时车日统计表对象信息 <br>
     * Version1.0 2021-10-09 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyTempCarStatistics (TempCarStatistics entity);

    /**
     * Description: 删除  临时车日统计表对象信息 <br>
     * Version1.0 2021-10-09 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeTempCarStatisticsById (Long id);

    List<TempCarStatistics> getCarReportList(Long parkId, String startTime, String endTime);
}
