package com.icetech.cloudcenter.api.report;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.report.domain.entity.PaymentRebateDayReport;
import com.icetech.report.domain.vo.IncomeVo;
import com.icetech.report.domain.vo.RebateVo;

import java.math.BigDecimal;
import java.util.List;

/**
 * 支付返利日结表 服务类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2023-10-23
 */
public interface PaymentRebateDayReportService extends IBaseService<PaymentRebateDayReport> {

    /**
     * Description: 根据ID查询 支付返利日结表对象信息 <br>
     * Version1.0 2023-10-23 by wanggang创建
     *
     * @param id 对象id
     * @return PaymentRebateDayReport
     */
    PaymentRebateDayReport getPaymentRebateDayReportById(Long id);

    /**
     * Description: 新增  支付返利日结表对象信息 <br>
     * Version1.0 2023-10-23 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addPaymentRebateDayReport(PaymentRebateDayReport entity);

    /**
     * Description: 修改 支付返利日结表对象信息 <br>
     * Version1.0 2023-10-23 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyPaymentRebateDayReport(PaymentRebateDayReport entity);

    /**
     * Description: 删除  支付返利日结表对象信息 <br>
     * Version1.0 2023-10-23 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removePaymentRebateDayReportById(Long id);

    /**
     * 获取昨日支付返利金额列表
     *
     * @param reportDay
     * @return
     */
    List<RebateVo> getYesterdayPayRebate(Long reportDay);

    /**
     * 获取年返利总金额
     *
     * @param year
     * @return
     */
    BigDecimal getYearSumRebate(int year);

    /**
     * 获取返利年数据
     *
     * @param year
     * @return
     */
    List<IncomeVo> getRebateYearData(Integer year);

    /**
     * 获取返利月数据
     *
     * @param yearAndMonth
     * @return
     */
    List<IncomeVo> getRebateMonthData(Integer yearAndMonth);
}
