package com.icetech.cloudcenter.api.parkvip;

import com.icetech.cloudcenter.domain.parkvip.VipProductDto;
import com.icetech.cloudcenter.domain.parkvip.VipProductRule;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.List;

/**
 * 会员权益服务类
 * @author wangzhiwei
 */
public interface IVipProductService {
    /**
     * 判断该车场是否属于VIP
     * @param parkCode
     * @return
     */
    ObjectResponse<List<VipProductDto>> getParkProduct(String parkCode);

    /**
     * 获取体验套餐
     * @param parkCode
     * @return
     */
    ObjectResponse<VipProductRule> getTryProduct(String parkCode);

    /**
     * 获取套餐信息
     * @param productId
     * @return
     */
    ObjectResponse<VipProductRule> getProduct(Integer productId);

}
