package com.icetech.cloudcenter.api.parkvip;

import com.icetech.cloudcenter.domain.pay.OpenParkVipDto;
import com.icetech.cloudcenter.domain.parkvip.ParkTypeNumDto;
import com.icetech.cloudcenter.domain.parkvip.ParkVipDto;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;

/**
 * @author wangzhiwei
 */
public interface IParkVipService {
    /**
     * 判断该车场是否属于VIP
     * @param parkCode
     * @return
     */
    ObjectResponse<Boolean> judgeParkVip(String parkCode);

    /**
     * 获取车场vip信息
     * @param parkCode
     * @return
     */
    ObjectResponse<ParkVipDto> getParkVipInfo(String parkCode);

    /**
     * 开通vip
     * @param openParkVipDto
     * @return
     */
    ObjectResponse<Void> openVip(OpenParkVipDto openParkVipDto);

    /**
     * 统计车场类型
     * @param userId
     * @return
     */
    ObjectResponse<ParkTypeNumDto> countPark(Integer userId);

    /**
     * 分页加载车场
     * @param pageNo
     * @param pageSize
     * @param parkCode
     * @param status
     * @return
     */
    ObjectResponse<Page<ParkVipDto>> getParkVipList(Integer pageNo, Integer pageSize, Integer userId, String parkCode, Integer status);

    /**
     * 分页加载车场信息带有结账金额
     * @param pageNo
     * @param pageSize
     * @param userId
     * @param parkCode
     * @return
     */
    ObjectResponse<Page<ParkVipDto>> getParkVipListWithMoney(Integer pageNo, Integer pageSize, Integer userId, String parkCode);
}
