package com.icetech.cloudcenter.api.park;

import java.util.Collection;
import java.util.Map;

import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.common.domain.response.ObjectResponse;

public interface ParkFreeSpaceService {
    ObjectResponse<ParkFreespace> getSpaceByPark(long parkId);

    /**
     *
     * @param parkIds
     * @return Map<parkId, ParkFreespace>
     */
    ObjectResponse<Map<Long, ParkFreespace>> getSpacesByPark(Collection<Long> parkIds);

    boolean insertFreeSpace(ParkFreespace space);

    boolean updateByPark(ParkFreespace space);

    int addFreeSpaceByPark(long parkId, int num);

    /**
     *
     * @param parkMap <parkId, num>
     * @return
     */
    int addFreeSpaceByParks(Map<Long, Integer> parkMap);

    boolean updateBatchByParkId(Collection<ParkFreespace> list);

    int updateFreeSpace(Long parkId);
}
