package com.icetech.cloudcenter.api.park;

import com.icetech.cloudcenter.domain.response.ChannelAlarmDto;
import com.icetech.park.domain.entity.ChannelAlarm;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 进出口报警记录表 服务类
 * </p>
 *
 * @author fangct
 * @since 2020-06-16
 */
public interface ChannelAlarmService {

    /**
     * 添加报警记录
     * @param channelAlarm
     * @return
     */
    ObjectResponse addAlarm(ChannelAlarm channelAlarm);

    /**
     * 根据id更新状态；如果id为空，则根据车场id和通道编号查询后更新
     * @param channelAlarm
     * @return
     */
    ObjectResponse updateStatus(ChannelAlarm channelAlarm);

    /**
     * 查询滞留车辆信息
     * @param parkId        车场id
     * @param channelCode   通道id
     * @return ChannelAlarm
     */
    List<ChannelAlarm> getChannelAlarmByPark(Long parkId, String channelCode);

    /**
     * 查询滞留时间超过当前设置时长的滞留记录
     * @param parkId
     * @param status
     * @param time
     * @return
     */
    List<ChannelAlarm> getChannelAlarmTimeOut(Long parkId, Integer status, Date time);


    /**
     * 获取出入口异常消息
     * @return
     */
    ObjectResponse<List<ChannelAlarmDto>> getChannelAlarm(String parkCodes, Integer pageNo, Integer pageSize);

    /**
     * 滞留车辆数查询
     * @param parkCodes
     * @return
     */
    ObjectResponse<Integer> getChannelAlarmCount(String parkCodes);


}
