package com.icetech.cloudcenter.api.order;


import com.icetech.cloudcenter.domain.request.DiscountRequest;
import com.icetech.cloudcenter.domain.request.QueryDiscountRequest;
import com.icetech.common.domain.Page;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.order.domain.dto.DiscountDto;
import com.icetech.order.domain.entity.OrderDiscount;

import java.util.List;
import java.util.Map;

public interface OrderDiscountService {

    ObjectResponse modifyDiscount(DiscountRequest discountRequest);

    /**
     * 查询流水号对应的优惠
     * @param tradeNo
     * @param parkId
     * @return
     */
    ObjectResponse<Map<String, String>> findDiscountNos(String tradeNo, Long parkId);

    /**
     * 查询单条优惠记录
     * @param orderDiscount
     * @return
     */
    ObjectResponse<OrderDiscount> findOne(OrderDiscount orderDiscount);

    /**
     * 添加优惠
     * @param orderDiscount
     * @return 优惠券ID
     */
    ObjectResponse<Long> addDiscount(OrderDiscount orderDiscount);


    /**
     * 批量添加优惠
     *
     * @param orderDiscounts
     * @return
     */
    ObjectResponse<Boolean> addDiscounts(List<OrderDiscount> orderDiscounts);

    ObjectResponse<List<OrderDiscount>> findList(OrderDiscount orderDiscount);

    /**
     * 查询总的优惠金额
     * @param parkId
     * @param orderNum
     * @param status
     * @param from
     * @return
     */
    ObjectResponse<Double> getSumDiscount(Long parkId, String orderNum, Integer from, Integer status);

    /**
     * 更新优惠券数据
     */
    ObjectResponse updateDiscount(OrderDiscount orderDiscount);

    /**
     * 根据车牌号查询最近的单个优惠
     * @param parkId
     * @param plateNum
     * @return
     */
    ObjectResponse<OrderDiscount> findOneByPlateNum(Long parkId, String plateNum);

    /**
     * 分页查询优惠信息
     * @param parkId
     * @param request
     * @return
     */
    ObjectResponse<Page<OrderDiscount>> getOrderDiscountList(Long parkId, QueryDiscountRequest request);

    /**
     * 统计当前订单发放的优惠券
     * @param orderNum
     * @return
     */
    ObjectResponse<Integer> countNumByOrderNum(String orderNum, Long parkId);

    /**
     * 取消优惠
     * @param id id
     * @return 影响行数
     */
    ObjectResponse<Integer> cancelDiscount(Long id, Long parkId);

    /**
     * 通过订单号和状态查询优惠列表
     * @param orderNums
     * @param status
     * @return
     */
    List<OrderDiscount> findDiscountByOrderNum(List<String> orderNums, Integer status);

    /**
     * 查询优惠记录
     * @param dto 参数
     * @return 结果集
     */
    List<DiscountDto> findList(DiscountDto dto);

    /**
     * 查询某条记录
     * @param id 唯一ID
     * @return
     */
    DiscountDto findOne(Long id);

    /**
     * 查询商户/三方名称
     * @param parkId 车场ID
     * @param discountNo 优惠编号
     * @param orderNum 订单号
     * @return 商户/三方名称
     */
    String findMerchantName(Long parkId, String discountNo, String orderNum);

}
