package com.icetech.cloudcenter.api.month;

import com.icetech.fee.domain.entity.monthcar.MonthrenewePubcheck;
import com.icetech.cloudcenter.domain.response.MonthInfoDto;
import com.icetech.db.mybatis.base.service.IBaseService;

import java.util.List;

/**
 * 月卡续费审核表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2021-12-31
 */
public interface MonthrenewePubcheckService extends IBaseService<MonthrenewePubcheck> {

    /**
     * Description: 根据ID查询 月卡续费审核表对象信息 <br>
     * Version1.0 2021-12-31 by wanggang创建
     *
     * @param id 对象id
     * @return MonthrenewePubcheck
     */
    MonthrenewePubcheck getMonthrenewePubcheckById (Long id);

    /**
     * Description: 新增  月卡续费审核表对象信息 <br>
     * Version1.0 2021-12-31 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addMonthrenewePubcheck (MonthrenewePubcheck entity);

    /**
     * Description: 修改 月卡续费审核表对象信息 <br>
     * Version1.0 2021-12-31 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyMonthrenewePubcheck (MonthrenewePubcheck entity);

    /**
     * Description: 删除  月卡续费审核表对象信息 <br>
     * Version1.0 2021-12-31 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeMonthrenewePubcheckById (Long id);

    List<MonthInfoDto> selectMonthInfo(Integer mpUserId);
    MonthrenewePubcheck selectByTradeNo(String tradeNo);
}
