package com.icetech.cloudcenter.api.month;

import java.util.List;

import com.icetech.cloudcenter.domain.park.query.ParkQuery;
import com.icetech.cloudcenter.domain.park.query.ParkSpaceMsgInfo;
import com.icetech.cloudcenter.domain.pay.MonthOpenCardDto;
import com.icetech.common.domain.Page;
import com.icetech.fee.domain.entity.monthcar.MonthProduct;
import com.icetech.cloudcenter.domain.response.MonthProductDto;
import com.icetech.common.domain.response.ObjectResponse;

public interface MonthProductService {
    /**
     * 查询产品信息
     *
     * @param monthProductId
     * @return
     */
    // TODO 更改类型为 ObjectResponse<MonthProduct>
    MonthProduct selectMonthProductById(Long monthProductId);

    ObjectResponse<MonthProduct> getValidMonthProduct(Long parkId, String plateNum);

    ObjectResponse<MonthProduct> getValidMonthProduct(Long parkId, String plateNum, Long regionId);

    /**
     * 获取车场的在售月且可以续费的月卡卡产品
     *
     * @param parkCode
     * @return
     */
    ObjectResponse<List<MonthProductDto>> getMonthProductList(String parkCode, Long monthInfoId);

    ObjectResponse<List<MonthProductDto>> getMonthProductList(String parkCode);

    /**
     * 国控新版获取月卡套餐分页
     *
     * @param parkQuery
     * @return
     */
    ObjectResponse<Page<ParkSpaceMsgInfo>> getParkSpacePage(ParkQuery parkQuery);

    void getMonthStatus(MonthOpenCardDto req);

    /**
     * 获取月卡信息
     *
     * @param productId 月卡 ID
     * @return page
     */
    ObjectResponse<Page<ParkSpaceMsgInfo>> getMonthById(Long productId);
}
