package com.icetech.cloudcenter.api.month;

import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.domain.pay.MonthOpenCardDto;
import com.icetech.cloudcenter.domain.pay.MonthRenewCardDto;
import com.icetech.cloudcenter.domain.request.MonthPayRequest;
import com.icetech.cloudcenter.domain.request.MonthReportRequest;
import com.icetech.cloudcenter.domain.response.*;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.fee.domain.entity.monthcar.*;
import com.icetech.park.domain.dto.InvoiceParksDto;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 月卡操作
 * @author wangzw
 */
public interface MonthCarService {

    /**
     * 车主端小程序月卡统计
     * @param monthReportRequest
     * @return
     */
    ObjectResponse<MonthReportDto> countMonthCarReport(MonthReportRequest monthReportRequest);
    /**
     * 获取月卡开卡记录表
     * @param parkCode
     * @param plateNumber
     * @return
     */
    ObjectResponse<List<MonthInfoDto>> getMonthCarList(String parkCode, String plateNumber, List<Integer> cardStatus, Integer pageNo, Integer pageSize, String startTime, String endTime, String cardOwner, String telephone, String productName, Integer validDays, Integer cardProperty);
    /**
     * 汇总月卡开卡记录表的条数
     * @param parkCode
     * @param plateNumber
     * @return
     */
    ObjectResponse<Map<String, Object>> countMonthCarList(String parkCode, String plateNumber, List<Integer> cardStatus, String startTime, String endTime, String cardOwner,String telephone,String productName,Integer validDays,Integer cardProperty);

    /**
     * 获取月卡开卡记录详情
     * @param recordId
     * @return
     */
    ObjectResponse<MonthInfoDto> getMonthCarDetail(String parkCode,Integer recordId);

    ObjectResponse<MonthRecord> getMonthRecordById(Integer recordId);

    /**
     * 获取月卡信息
     * @param parkId
     * @param plateNum
     * @return
     */
    ObjectResponse<MonthInfo> getValidMonthCar(Long parkId, String plateNum);
    ObjectResponse<MonthInfo> getValidMonthCar(Long parkId, String plateNum, String channelCode);
    ObjectResponse<MonthInfo> getValidMonthCar(Long parkId, String plateNum, Long regionId);

    ObjectResponse<MonthProduct> getValidMonthProduct(Long parkId, String plateNum);
    ObjectResponse<MonthProduct> getValidMonthProduct(Long parkId, String plateNum, Long regionId);

    /**
     * 获取最新月卡记录
     * @param parkId
     * @param plateNum
     * @param phone
     * @return
     */
    ObjectResponse<MonthInfoDto> getNewestMonthCar(Long parkId, String plateNum, String phone);

    /**
     * 按车牌号 或者手机号搜索
     * @param searchKey 手机号或者车牌号模糊搜索
     * @return
     */
    ObjectResponse<List<MonthInfoDto>> getMonthCarList(String searchKey,List<String> plateNums,Integer pageNo, Integer pageSize);

    /**
     * 小程序
     * @param searchKey
     * @param plateNums
     * @param pageNo
     * @param pageSize
     * @return
     */
    ObjectResponse<List<MonthInfoDto>> getAppletMonthCarList(String searchKey,List<String> plateNums,Integer pageNo, Integer pageSize);

    /**
     * 获取月卡明细
     * @param monthId
     * @return
     */
    ObjectResponse<MonthInfoDto> getAppletMonthCarDetail(Long monthId);

    /**
     * 获取车场的在售月且可以续费的月卡卡产品
     * @param parkCode
     * @return
     */
    ObjectResponse<List<MonthProductDto>> getMonthProductList(String parkCode, Long monthInfoId);
    ObjectResponse<List<MonthProductDto>> getMonthProductList(String parkCode);

    /**
     * 获取公众号月卡的续费记录
     */
    ObjectResponse<List<MonthOrderDto>> getMonthOrderList(Integer mpUserId, Date startTime, Date endTime, List<Integer> optionTypes,Integer pageNo, Integer pageSize);
    ObjectResponse<List<MonthOrderDto>> getMonthOrderList(Long accountId, String plateNum,Date startTime, Date endTime,Integer bizType,Integer pageNo, Integer pageSize);

    /**
     * 获取公众号月卡续费详情
     * @param monthOrderId
     * @return
     */
    ObjectResponse<MonthOrderDto> getMonthOrderDetail(Long monthOrderId);

    /**
     * 查询产品信息
     * @param monthProductId
     * @return
     */
    // TODO 更改类型为 ObjectResponse<MonthProduct>
    MonthProduct selectMonthProductById(Integer monthProductId);
    // TODO 更改类型为 ObjectResponse<MonthInfo>
    MonthInfo selectMonthInfotById(Integer monthInfoId);

    /**
     * 保存月卡订单记录
     */
    ObjectResponse<Void> saveMonthOrder(MonthOrder monthOrder);

    /**
     * 完成月卡支付完成
     * @return
     */
    ObjectResponse<Void> finishMonthPay(MonthPayRequest monthPayRequest);

    /**
     * 获取月卡订单信息
     */
    ObjectResponse<MonthOrderDto> getMonthOrder(String tradeNo);

    /**
     * 是否多车多车位
     * @return
     */
    // TODO 更改类型为 ObjectResponse<Boolean>
    boolean isAbCar(Long parkId, String plateNum, long monthId, int plotCount);

    /**
     * 多位多车判断后是否为月卡
     * @param parkId
     * @param plateNum
     * @param monthId
     * @param plotCount
     * @return
     */
    ObjectResponse<MonthAbDto> abMonthCar(Long parkId, String plateNum, long monthId, int plotCount);

    /**
     * 内场AB车判断，支持场中场内外场
     * @param parkId 车场ID
     * @param plateNum 车牌号
     * @param monthId 月卡ID
     * @return AB车对象
     */
    ObjectResponse<MonthAbDto> abMonthCar(Long parkId, String plateNum, long monthId, int plotCount, Long regionId);

    /**
     *  集团月卡AB车判断
     * @param plateNum
     * @param monthId
     * @param plotCount
     * @return
     */
    ObjectResponse<MonthAbDto> groupAbMonthCar(String plateNum, long monthId, int plotCount);

    /**
     * 月卡
     * @param parkId
     * @param plateNum
     * @param regionId
     * @return
     */
    MonthAbDto abMonthCar(Long parkId, String plateNum, Long regionId);

    /**
     * 获取有效期内月卡
     * @param parkId
     * @param plateNum
     * */
    ObjectResponse<MonthInfo> getMonthCar(Long parkId,String plateNum);


    /**
     * 获取区域月卡
     * @param parkId
     * @param plateNum
     * @param regionId
     * @return
     */
    ObjectResponse<MonthInfo> getMonthCar(Long parkId,String plateNum, Long regionId);

    /**
     * 根据状态获取区域月卡
     * @param parkId
     * @param plateNum
     * @param cardStatus
     * @param regionId
     * @return
     */
    ObjectResponse<MonthInfo> getMonthInfo(long parkId, String plateNum, int cardStatus, Long regionId);

    /**
     * 获取月卡详情
     * @param parkId
     * @param plateNum
     * @return
     */
    ObjectResponse<MonthDetailDto> getMonthCarDetail(Long parkId, String plateNum);
    ObjectResponse<MonthDetailDto> getMonthCarDetail(Long parkId, String plateNum, Long regionId);

    /**
     * 添加月卡
     * @param monthInfo
     * @return
     */
    // TODO 更改类型为 ObjectResponse<Boolean>
    boolean addMonthCarInfo(MonthInfo monthInfo);
    /**
     * 获取生效中的月卡，只查询全天卡和已经生效的月卡
     * @param parkId
     * @return
     */
    ObjectResponse<List<MonthCardDto>> getValidByParkId(Long parkId);
    ObjectResponse<List<MonthCardDto>> getValidByIds(List<String> isList);

    /**
     * 月卡续费
     */
    ObjectResponse<Void> renewMonthCard(MonthInfo renewMonthInfo,String parkCode,String plateNum,String plotNum);

    /**
     * 根据月卡id获取所有关联车牌的所有开卡纪录
     * @param monthId
     * @param parkId
     * @return
     */
    ObjectResponse<List<MonthInfo>> getMonthCarByPlateNum(Long monthId, Long parkId);

    /**
     * 通过id列表 查询操作记录ID列表
     * @param ids
     * @return
     */
    ObjectResponse<List<Long>> getRecordIdListByIds(List<Long> ids);


    List<MonthCardDto> getMonthListByParkId(Long parkId);


    /**
     * 添加月卡审核记录
     * @param monthrenewePubcheck
     * @return
     */
    ObjectResponse<Boolean> addMonthCardRenewRecode(MonthrenewePubcheck monthrenewePubcheck);

    /**
     * 分页查询
     *
     * @param parkCode
     * @param plateNums
     * @return
     */
    List<MpMonthInvoiceResponse> getMonthInvoiceRecords(String parkCode, List<String> plateNums, Integer pageNo, Integer pageSize);

    /**
     * 获取月卡开票列表
     * @param parkCode
     * @param accountId
     * @param bizType
     * @param startTime
     * @param endTime
     * @param pageNo
     * @param pageSize
     * @return
     */
    List<MpMonthInvoiceResponse> getMonthInvoiceRecords(String parkCode, Long accountId, Integer bizType,Long startTime,Long endTime,Integer pageNo, Integer pageSize);

    /**
     * 获取月卡开票列表
     * @param plateNums
     * @param startTime
     * @param endTime
     * @return
     */
    List<InvoiceParksDto> getMonthInvoiceParks(List<String> plateNums, Long startTime, Long endTime);

    /**
     * 获取可以开发票的车场信息
     * @param accountId 用户id
     * @param bizType 业务类型
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @return
     */
    List<InvoiceParksDto> getMonthInvoiceParks(Long accountId, Integer bizType,Long startTime, Long endTime);


    /**
     * 查询月卡订单
     * @param trades
     * @return
     */
    List<MonthOrder> getMonthMonthOrderByTradeNos(List<String> trades);

    /**
     * 查询月卡记录
     * @param monthRecords
     * @return
     */
    List<MonthRecord> getMonthRecordByIds(List<Long> monthRecords);

    /**
     * 更新开票状态
     * @param tradelist
     */
    void batchUpdateInvoiceStatus(List<String> tradelist);

    /**
     * 月卡开卡
     * @param monthOpenCardDto 月卡开卡详情
     * @param isCheck 是否校验 只校验不开卡
     * @return
     */
    ObjectResponse<Object> openCard(MonthOpenCardDto monthOpenCardDto, Boolean isCheck);

    /**
     * 月卡续费
     * @param monthRenewCardDto
     * @param isCheck
     * @return
     */
    ObjectResponse<Object> renewCard(MonthRenewCardDto monthRenewCardDto, Boolean isCheck);

    /**
     * 获取产品详情新年喜
     * @param parkCode
     * @param productId
     * @return
     */
    ObjectResponse<MonthProductDto> getMonthProduct(String parkCode, Integer productId);

    /**
     * 查询当前用户办理的月卡信息
     * @param id
     * @return
     */
    ObjectResponse<List<MonthInfoDto>> getMpUserMonthInfo(Integer id);

    /**
     * 场中场车场-查询当前车牌在当前区域外的月卡区域
     * @param parkId 车场ID
     * @param plateNum 车牌号
     * @param channelCode 通道编号
     * @return 车场区域
     */
    ParkRegion findMonthCardOtherRegion(Long parkId, String plateNum, String channelCode);

    /**
     * 查询月卡信息，支持分区月卡
     * @param parkId 车场ID
     * @param plateNum 车牌号
     * @param regionId 区域ID
     * @param cardStatus 月卡状态
     * @return 月卡信息
     */
    MonthInfo findMonthInfo(Long parkId, String plateNum, Long regionId, Integer cardStatus);

    /**
     * 查询月卡的配置
     * @param monthInfoId
     * @return
     */
    ObjectResponse<MonthCardConfigDto> limitConfig(Long monthInfoId);

    /**
     * 统计订单数据
     * @param accountId
     * @param plateNum
     * @param startTime
     * @param endTime
     * @param bizType
     * @return
     */
    ObjectResponse<MonthOrderCountDto> countMonthOrderList(Long accountId, String plateNum, Date startTime, Date endTime, Integer bizType);

    /**
     * 获取月卡购买记录
     *
     * @param cardType
     * @param plateNums
     * @return
     */
    ObjectResponse<List<MonthOrderResponseVo>> getMonthOrderListBy(Integer cardType, List<String> plateNums);

    ObjectResponse<List<MonthInfo>> getMonthInfos(Long parkId, Date date);

    ObjectResponse<List<MonthOrder>> getMonthOrders(Long parkId, Date date);

    ObjectResponse<List<MonthRecord>> getMonthRecordList(List<Long> ids);


    ObjectResponse<List<MonthPlate>> getMonthPlatesByMonthId(Long monthId);
}
