package com.icetech.cloudcenter.api.lcd;


import com.icetech.cloudcenter.domain.response.LedShowDto;
import com.icetech.cloudcenter.domain.response.LedSoundDto;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.led.LedSound;
import com.icetech.park.domain.entity.led.LedTips;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.List;
import java.util.Map;

/**
 *  屏显相关操作
 * @author fangct
 */
public interface LedService {

    /**
     * 查询显示配置
     * @param channelId
     * @return
     */
    ObjectResponse<List<LedShowDto>> getLedShowDtoByChannel(Long channelId);

    /**
     * 查询某类型的显示配置
     * @param channelId
     * @return
     */
    ObjectResponse<LedShowDto> getLedShowByType(Long channelId, int type);

    /**
     * 查询LED显示配置
     * @param channelId
     * @return key: displayType
     */
    Map<Integer, LedShowDto> getLedShowDtoMapByChannel(Long channelId);

    /**
     * 查询语音配置
     * @param channelId
     * @return
     */
    ObjectResponse<List<LedSoundDto>> getLedSoundDtoByChannel(Long channelId);
    /**
     * 查询某类型的语音配置
     * @param channelId
     * @return
     */
    ObjectResponse<LedSoundDto> getLedSoundDtoByType(Long channelId, int type);

    /**
     * 查询LED语音配置
     * @param channelId
     * @return key: type
     */
    Map<Integer, LedSoundDto> getLedSoundDtoMapByChannel(Long channelId);

    /**
     * 获取车场屏显和语音配置
     * @param channelId
     * @return
     */
    ObjectResponse<LedConfig> getLedConfigByChannel(Long channelId);
    /**
     * 获取车场屏显提示的配置
     * @param channelId
     * @return
     */
    ObjectResponse<LedTips> getLedTipsByChannel(Long channelId);

    /**
     * 查询LED显示配置
     * @param channelId
     * @return key: type
     */
    Map<String, List<LedShow>> getLedShowMapByChannel(Long channelId);

    /**
     * 查询LED语音配置
     * @param channelId
     * @return key: type
     */
    Map<String, LedSound> getLedSoundMapByChannel(Long channelId);
}
