package com.icetech.cloudcenter.api.lcd;


import com.icetech.cloudcenter.domain.response.LcdDto;
import com.icetech.cloudcenter.domain.response.LedSoundDto;
import com.icetech.park.domain.entity.lcd.LcdConfig;
import com.icetech.park.domain.entity.lcd.LcdShow;
import com.icetech.park.domain.entity.lcd.LcdSound;
import com.icetech.park.domain.entity.lcd.LcdSoundcode;
import com.icetech.park.domain.entity.lcd.LcdTips;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.List;
import java.util.Map;

/**
 *  LCD屏显语音相关操作
 * @author fangct
 */
public interface LcdService {

    /**
     * 查询显示配置
     * @param parkId
     * @return
     */
    ObjectResponse<List<LcdDto>> getLcdShowByChannel(Long channelId);

    /**
     * 查询某类型的显示配置
     * @param channelId
     * @return
     */
    ObjectResponse<LcdDto> getLcdShowByType(Long channelId, int type);

    /**
     * 查询LCD显示配置
     * @param channelId
     * @return key: displayType
     */
    Map<Integer, LcdDto> getLcdShowDtoMapByChannel(Long channelId);

    /**
     * 查询LCD显示配置
     * @param channelId
     * @return key: type
     */
    Map<String, List<LcdShow>> getLcdShowMapByChannel(Long channelId);

    /**
     * 查询语音配置
     * @param channelId
     * @return
     */
    ObjectResponse<List<LedSoundDto>> getSoundConfigByChannel(Long channelId);
    /**
     * 查询某类型的语音配置
     * @param channelId
     * @return
     */
    ObjectResponse<LedSoundDto> getSoundConfigByType(Long channelId, int type);

    /**
     * 查询LCD语音配置
     * @param channelId
     * @return key: soundType
     */
    Map<Integer, LedSoundDto> getSoundDtoMapByChannel(Long channelId);

    /**
     * 查询LCD语音配置
     * @param channelId
     * @return key: type
     */
    Map<String, List<LcdSound>> getLcdSoundMapByChannel(Long channelId);

    /**
     * 获取车场屏显和语音配置
     * @param channelId
     * @return
     */
    ObjectResponse<LcdConfig> getLcdConfigByChannel(Long channelId);
    /**
     * 获取车场屏显提示的配置
     * @param channelId
     * @return
     */
    ObjectResponse<LcdTips> getLcdTipsByChannel(Long channelId);

    /**
     * 获取语音编码集
     * @param soundCode
     * @return
     */
    ObjectResponse<LcdSoundcode> getLcdSoundCode(String soundCode);

    /**
     * 获取所有语音编码集
     * @return
     */
    ObjectResponse<List<LcdSoundcode>> getAllLcdSoundCodes();
}
