package com.icetech.cloudcenter.api.fee;

import com.icetech.cloudcenter.domain.charge.detail.Charge24HourDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeDayNightDetail;
import com.icetech.cloudcenter.domain.charge.detail.ChargeNaturalDayDetail;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.RegionChargeconfig;
import com.icetech.common.domain.response.ObjectResponse;

import java.util.List;

/**
 * Description : 计费配置接口
 * @author fangct
 */
public interface ChargeService {
    /**
     * 获取区域的计费规则列表
     *
     * @param parkId
     * @return
     */
    ObjectResponse<List<RegionChargeconfig>> getRegionConfigs(Long parkId);

    /**
     * 获取车场的所有计费规则列表
     *
     * @param parkId
     * @return
     */
    ObjectResponse<ParkChargeconfig> getConfigsBycode(Long parkId, String billCode);

    /**
     * 获取车场的计费规则列表
     *
     * @param parkId
     * @return
     */
    ObjectResponse<List<ParkChargeconfig>> getConfigs(Long parkId);

    /**
     * 获取车场默认的计费规则
     * @param parkId
     * @return
     */
    ObjectResponse<ParkChargeconfig> selectDefaultBill(Long parkId);

    /**
     * 查询通用自然天计费配置
     *
     * @param billtypecode
     * @return
     */
    ObjectResponse<ChargeNaturalDayDetail> getNaturalday(String billtypecode);

    /**
     * 查询白天夜间计费配置
     *
     * @param billtypecode
     * @return
     */
    ObjectResponse<ChargeDayNightDetail> getDaynight(String billtypecode);

    /**
     * 查询24小时计费配置
     *
     * @param billtypecode
     * @return
     */
    ObjectResponse<Charge24HourDetail> get24Hours(String billtypecode);

    /**
     *
     * @param regionId
     * @param orderNum
     * @param plateNum
     * @param parkId
     * @return
     */
    ParkChargeconfig getParkChargeConfigByPlateColor(Long regionId, String orderNum, String plateNum, Long parkId);

    /**
     * 通过id获取计费规则
     *
     * @param id
     * @return
     */
    ParkChargeconfig getParkChargeConfigById(Integer id);

    /**
     * 不带删除标识的查询
     * @param parkId
     * @param billCode
     * @return
     */
    ObjectResponse<ParkChargeconfig> getConfigsBycodeWithoutDelFlag(Long parkId, String billCode);
}
