package com.icetech.cloudcenter.api.discount;

import com.icetech.cloudcenter.domain.response.DiscountUsedDto;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.cloudcenter.domain.response.MerchantDiscountDto;
import com.icetech.cloudcenter.domain.response.OrderDiscountDto;
import com.icetech.cloudcenter.domain.response.RechargeDetailDto;
import com.icetech.cloudcenter.domain.response.RechargeListDto;
import com.icetech.fee.domain.entity.merchant.DiscountDay;
import com.icetech.fee.domain.entity.merchant.MerchantDiscount;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.park.domain.vo.FindDiscountVo;

import java.util.Date;
import java.util.List;

/**
 * 商家优惠服务
 * @author wangzw
 */
public interface MerchantDiscountService {
    /**
     * 获取商户的优惠模板
     * @param merchantId
     * @return
     */
    ObjectResponse<List<MerchantDiscountDto>> getDiscountTemplate(Long merchantId);

    /**
     * 获取按天优免的类型
     * @param merchantId
     * @return
     */
    ObjectResponse<MerchantDiscountDto> getDayDiscountTemplate(Long merchantId);

    /**
     * 获取详情的模板信息
     * @param disId
     * @return
     */
    ObjectResponse<MerchantDiscountDto> findMerchantDiscountById(Long disId);

    /**
     * 获取当前商家优惠券 已领取的记录
     * @param vo
     * @return
     */
    ObjectResponse<List<OrderDiscountDto>> findDiscountRecords(FindDiscountVo vo);
    ObjectResponse<DiscountUsedDto> findDiscountUsedRecords(FindDiscountVo vo);

    /**
     * 根据id 获取优惠券记录的详情信息
     * @param id
     * @return
     */
    ObjectResponse<OrderDiscountDto> findDiscountRecord(Long id);

    /**
     * 查询充值记录
     * @param merchantId
     * @param selectType
     * @param yearMonth
     * @param startDate
     * @param endDate
     * @return
     */
    ObjectResponse<List<RechargeListDto>> findRechargeList(Long merchantId, Integer selectType,
                                                           String yearMonth, String startDate, String endDate,List<Integer> rechargeTypes,List<Integer> payWays);

    /**
     * 查询充值详情
     * @param recordId
     * @return
     */
    ObjectResponse<RechargeDetailDto> findRechargeDetail(Integer recordId);

    /**
     * 查询优惠模板信息
     * @param disId
     * @return
     */
    ObjectResponse<MerchantDiscount> findTemplateInfo(Long disId);

    /**
     * 插入优惠车牌信息
     */
    ObjectResponse saveDiscountPlateNum(DiscountDay discountDay);
    /**
     * 查询有效的按天优免
     */
    ObjectResponse<DiscountDay> findValidDiscountDay(String plateNum, Long parkId, String payTime);

    /**
     *
     * @param discountNo
     * @param parkId
     * @return
     */
    ObjectResponse<DiscountDay> findDiscountDay(String discountNo, Long parkId);

    /**
     * 校验车票在当前时间是否存按天优免
     */
    ObjectResponse findValidExistedDisCountDay(String palteNum,Long parkId);

    /**
     * 校验当前发放按天优免的车位数限制
     * @param merchantId
     * @return
     */
    ObjectResponse checkSpaceNum(Integer merchantId);

    /**
     * 扣减优惠的车位数
     * @param merchantId
     * @return
     */
    ObjectResponse subDiscountSpaceNum(Integer merchantId);

    /**
     *
     * 按天优免释放车位数
     */
    ObjectResponse addDiscountDaySpaceNum();

    /**
     * 查询按天优免是否存在
     * @param plateNum
     * @param parkId
     * @return
     */
    ObjectResponse<DiscountDay> selectLastByPlateNum(String plateNum,Long parkId);

    /**
     * 更新按天优免
     * @param discountDay
     * @return
     */
    ObjectResponse updateDiscountDay(DiscountDay discountDay);

    /**
     * 根据车牌号和优惠模板ID查询按天优惠
     * @param plateNum
     * @param parkId
     * @param disId
     * @return
     */
    ObjectResponse<DiscountDay> findLastDisDayByPlateAndDisId(String plateNum, Long parkId, Long disId);

    /**
     * 根据车牌和自然天领取一次的条件查询最近优惠
     *
     * @param plateNum 车牌号
     * @param parkId   车场ID
     * @return {@link ObjectResponse}<{@link DiscountDay}>
     */
    ObjectResponse<DiscountDay> findLastDisDayByPlateAndOnceDay(String plateNum, Long parkId);

    /**
     * 根据车牌号和优惠模板ID查询按天优惠
     * @param plateNum
     * @param parkId
     * @param disId
     * @return
     */
    ObjectResponse<OrderDiscount> findLastDiscountByPlateAndDisId(String plateNum, Long parkId, Long disId);


    /**
     * 根据车牌和自然天领取一次的条件查询最近优惠
     *
     * @param plateNum 车牌号
     * @param parkId   车场ID
     * @return {@link ObjectResponse}<{@link OrderDiscount}>
     */
    ObjectResponse<OrderDiscount> findLastDiscountByPlateAndOnceDay(String plateNum, Long parkId);

}
