package com.icetech.cloudcenter.api;

import com.icetech.third.domain.entity.third.SendInfoRecord;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.ReflectUtils;

import java.lang.reflect.Type;

/**
 * 结果回调接口
 * @author fangct
 */
public interface NotifyService<T> {
    /**
     * 回调通知
     * @param messageId 消息ID
     * @param response 响应内容
     * @param sendInfoRecord 请求参数
     */
    default void notify(String messageId, ObjectResponse<String> response, SendInfoRecord<T> sendInfoRecord) {

    }

    default Type getReqGenericType() {
        return ReflectUtils.getInterfaceGenericTypeWrapper(NotifyService.class, this, SendInfoRecord.class);
    }
}
