package com.icetech.cloudcenter.api;

import java.util.List;

import javax.annotation.Nullable;

import com.icetech.cloudcenter.domain.vo.AisleInfoVo;
import com.icetech.park.domain.entity.ChannelAlarm;

public interface AlarmService {

    /**
     * 查询费用失败处理
     * @param parkCode
     * @param parkId
     * @param channelId
     * @return
     */
    void queryFeeFailHandler(String parkCode, @Nullable Long parkId, String channelId);

    /**
     * 开闸失败处理
     * @param parkCode
     * @param parkId
     * @param channelId
     */
    void switchFailHandler(String parkCode, Long parkId, String channelId);

    /**
     * 云翌呼叫增加 警告
     * @param serialNumber  设备sn
     */
    void yuneasyCallHandler(String serialNumber);

    /**
     * 通道时长警告
     * @param aisleInfoVo aisleInfoVo
     */
    void aisleDurationAlarm(AisleInfoVo aisleInfoVo);

    @Deprecated
    List<ChannelAlarm> getAlarmsByChannelCode(Long parkId, String channelCode);
}
