package com.icetech.cloudcenter.domain.vo.p2c;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 以token为key，存放已注册设备信息
 */
@Setter
@Getter
@ToString
public class TokenDeviceVo implements Serializable {
    /**
     * 通道表ID
     */
    private Long id;
    /**
     * 车场ID
     */
    private Long parkId;
    /**
     * 车场编号
     */
    private String parkCode;
    /**
     * 设备序列号
     */
    private String deviceNo;
    /**
     * 出入口名称
     */
    private String inandoutName;
    /**
     * 出入口编号
     */
    private String inandoutCode;
    /**
     * 区域ID
     */
    private Long regionId;
    /**
     * 出入口类型
     */
    private Integer inandoutType;
    /**
     * 版本号
     */
    private String version;
    /**
     * 来源，1：华夏相机直连，2：阿里物联网平台
     */
    private Integer source = 1;
    /**
     * 是否为主相机
     */
    private boolean isMaster = true;

    @Deprecated
    private Integer displayTerminal;

    private String token;

    private String originalServer;
    private String originalIp;
    private Integer newBluetooth;

    public enum ProtocolTypeEnum{
        WS(1), IOT(2), MQTT(3);
        public int val;
        ProtocolTypeEnum(int val){
            this.val = val;
        }
    }
}
