package com.icetech.cloudcenter.domain.vo;

import com.icetech.order.domain.entity.OrderNotpay;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Auther: lisc
 * @Date: 2018/9/27 14:09
 * @Description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class NotPayDetailVo implements Serializable {

    /**
     * 欠费追缴ID
     */
    private Long id;
    private Long parkId;
    private String parkCode;
    /**
     * 流水号
     */
    private String tradeNo;
    /**
     * 订单号
     */
    private String orderNum;
    /** 应付金额 */
    protected String totalPrice;
    /** 优惠金额 */
    protected String discountPrice;
    /** 欠费缴费金额，totalPrice = discountPrice + unPayPrice */
    protected String unPayPrice;
    /**
     * 车辆入场时间
     */
    private Date enterTime;
    /**
     * 车辆入场时间
     */
    private Date exitTime;
    /**
     * 停车时长
     */
    private String parkTime;
    /**
     * 是否加装监控相机，0：未装，1：已装
     */
    private Integer hasMorCamera;

    /** @see com.icetech.order.domain.entity.OrderNotpay#getOrderSource */
    private Integer orderSource = OrderNotpay.ORDER_SOURCE_PARK;

    public boolean isParkOrder() {
        return OrderNotpay.ORDER_SOURCE_PARK.equals(orderSource);
    }

    public boolean isRoadOrder() {
        return OrderNotpay.ORDER_SOURCE_ROAD.equals(orderSource);
    }
}
