package com.icetech.cloudcenter.domain.response.p2c;


import com.icetech.common.utils.StringUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

@Setter
@Getter
@ToString
public class CarEnexResponse implements Serializable {

    /**
     * 公共参数
     */
    private String orderNum = "";
    private Integer openFlag = 0;
    private String show = "";
    private String say = "";
    /**
     * LED参数，1：普通文本，2：二维码, 3:文本和二维码
     */
    private Integer showType = 1;
    /**
     * 显示设备类型，0：默认，1：LED，2：LCD
     */
    private Integer showDeviceType = 0;
    /**
     * LCD参数
     */
    private String qrCodeUrl = "";
    /**
     * 扩展显示内容
     */
    private String extendShow = "";

    public void setShowTypeByShow(String show) {
        // 二维码显示设置
        if (show != null && StringUtils.containsAny(show, "http://", "https://")) {
            if (show.contains("|")) {
                this.showType = 3;
            } else {
                this.showType = 2;
            }
        }
    }

}
