package com.icetech.cloudcenter.domain.response;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class QueryFeeRegionDetail implements Serializable {
    /** 内区域区域编号 */
    protected String regionCode;
    /** 内区域本次总金额，从上次支付时间至当前时间应收金额 */
    protected String totalAmount;
    /** 内区域本次优惠金额，从上次支付时间至当前时间优惠金额 */
    protected String discountPrice;
    /** 内区域储值卡扣除金额 */
    protected String balancePrice;
    /** 内区域本次应付金额，totalAmount = discountPrice + unpayPrice */
    protected String unpayPrice;
    /** 内区域本次应付金额，totalAmount = discountPrice + balancePrice + paidPrice */
    protected String paidPrice;

    /** 内区域区域ID */
    protected Long regionId;
    protected Long orderSonId;
    protected Long enterTime;
    protected Long exitTime;
    protected String plateNum;
    protected Integer plateType;
}
