package com.icetech.cloudcenter.domain.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.icetech.cloudcenter.domain.order.CustomerDoubleSerialize;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * 支付方式汇总
 * @author fangct
 */
@Getter
@Setter
@ToString
public class PayWayCountDto implements Serializable,Comparable<PayWayCountDto>{
    private String payWayName;
    @JsonSerialize(using = CustomerDoubleSerialize.class)
    private Double totalPayCount;
    private String ratio;
    private Integer order;
    @Override
    public int compareTo(PayWayCountDto o) {
        return this.order-o.order;
    }
}
