package com.icetech.cloudcenter.domain.response;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class PassWayDto implements Serializable {
    /**
     *机构id或者车场id
     */
    private Long id;
    /**
     *通道编号
     */
    private String aisleCode;
    /**
     *通道名称
     */
    private String aisleName;
    /**
     *监控相机视频播放地址
     */
    private String videoUrl;
    /**
     *语音对讲设备序列号
     */
    private String voiceDeviceId;
    /**
     * 车场id
     */
    private String parkCode;
    /**
     * 通道类型 入口 出口
     */
    private Integer type;
    /**
     *车场名称
     */
    private String parkName;
    /**
     *通道相机状态
     */
    private Integer status;
    /**
     *监控相机状态
     */
    private Integer vStatus;
    /**
     *设备状态离线列表
     */
    private List<Integer> statusFail;

    /**
     * 设备IP，可能为空
     */
    private String ip;
    /**
     * 设备端口，可能为空
     */
    private String port;
    /**
     * 云翌 号码
     */
    private String yuneasyNumber;

    /**
     * 托管状态,0-未开通， 1-未生效，2-托管中，3-托管到期
     */
    private Integer trusteeshipStatus;

    /**
     * 托管有效结束日期
     */
    private Date trusteeshipEndTime;
    /**
     * 华夏监控相机视频地址
     */
    private String iceMorVideoUrl;
    /**
     * 华夏监控相机SN
     */
    private String iceMorSn;

    /**
     * 数据上报方式:1端云;2端网云;3纯云
     */
    private Integer dataCollection;
}
