package com.icetech.cloudcenter.domain.response;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class OrderPayDto implements Serializable {

    private Integer id;

    /**
     * 车场名称
     */
    private String parkName;
    /**
     * 车牌号
     */
    private String plateNumber;
    /**
     * 车辆类型
     */
    private Integer type;
    /**
     * 支付时间
     */
    private Date payTime;
    /**
     * 交易流水号
     */
    private String tradeNo;
    /**
     * 支付方式
     */
    private Integer payWay;
    /**
     * 支付渠道
     */
    private Integer payChannel;
    /**
     * 总应收
     */
    private String totalPrice;
    /**
     * 总实收
     */
    private String paidPrice;
    /**
     * 总优惠
     */
    private String discountPrice;
    /**
     * 收费员名称
     */
    private String userAccount;

    /**
     * 停车时长
     */
    private Long parkTime;
    private String parkTimeStr;
    private String orderNum;
    private Integer carType;
    private String enterTime;
    private String exitTime;
    private Long enterTimeLong;
    private Long exitTimeLong;
    private String enterName;
    private String exitName;
    private String imgUrl;
    private Long parkId;
    private Long lastPayTime;
    /**
     *实际收钞金额
     */
    private Long actualCash;
    /**
     *红包找零金额
     */
    private Long redpackRet;
    /**
     *支付终端
     */
    private String payTerminal;
    /**
     * 现金收入
     */
    private Double paidCash;
    /**
     * 红包找零
     */
    private Double redPackage;
    /**
     * 储值卡扣减
     */
    private Double storeCardPrice;
    /**
     * 款项来源
     */
    private String payFrom;
    /**
     * 支付通道
     */
    private Integer payAisle;
    /**
     * 缴费类型，1：补缴
     */
    private Integer payType;
}
